TEST_MODE
;******************************************************************************
; To initiate TEST_MODE, prior to applying power, all setting of the dip-
; switch must be in the on positions, and the REVERSE and BRAKE push-buttons
; must be pressed simulataneously.
;
; The following tests excersize all inputs to the micro (switches, pots, Hall
; inputs, A/D converter) and verifys the operation of all outputs (bridge
; FETs and LEDs) 
;******************************************************************************
	bcf		HallAintFlag_b
	bcf		HallBintFlag_b
	bcf		HallCintFlag_b
	bsf		Timer0IntEnable_b	;turn on timer 0 interrupt for blinking LEDs
;	bsf		PeripheralIntEn_b	;Peripheral interrupts enable
	bsf		GlobalIntEnable_b	;Global interrupt enable
	
	EnableMux PushButton,PButtonInputs
	movlw	PButtonMask				
	andwf	PButtonInputs,w			;isolate the switch inputs
	btfsc	WREG,Brake
		bra	TstValidTestStart
	btfsc	WREG, Reverse	
		bra	InvalidTestMode					
	return							;return to normal program

TstValidTestStart
	btfss	WREG,Reverse
		bra InvalidTestMode
		
TestDipSetting
	EnableMux DipSwitch, DipSwInputs		
	swapf	DipSwInputs			;put dip settings in b0..b3
	movlw	0x0F
	andwf	DipSwInputs			;clear b4..b7
	movlw	0x0F
	cpfseq	DipSwInputs		
		bra InvalidTestMode
	bra		StartTest
	
InvalidTestMode	
	movlw	0x90
	TurnOnLED Wdata,Blink
	goto $
	
StartTest
	movlw	VersionNumber
	swapf	WREG
	TurnOnLED Wdata, NoBlink
VersionLoop
	call	PBUTTON_STATUS
	btfss	StartStop_b
		bra VersionLoop
	bcf		StartStop_b		;press StartStop button to turn on all LED
;..............................................................................
;  LED tests
;  All four LEDs are automatically turned on simultaneously to setup for the push
;  button tests
;..............................................................................
	movlw	0xF0
	TurnOnLED Wdata,NoBlink
;..............................................................................
; Push-button tests
;	Turn off the corresponding LED when the push buttons are pressed one at a 
;   time (except RESET). After Start/Stop, Reverse, and Brake are pressed, press
;	Brake one more time to turn off LED3 and to begin the hall input test
;..............................................................................
PbuttonTest
	call	PBUTTON_STATUS	;get status of Start/Stop, Reverse, Brake switches
	btfss	Brake_b	
		bra	tstSS		
	TurnOffLED	Brake	
tstSS
	btfss	StartStop_b	
		bra	tstRev	
	TurnOffLED	Run
tstRev
	btfss	Reverse_b
		bra tstRun
	TurnOffLED Reverse
tstRun
	btfsc	EnableLEDs_B,Run
		bra PbuttonTest
	btfsc	EnableLEDs_B,Reverse
		bra PbuttonTest
	btfsc	EnableLEDs_B,Brake
		bra PbuttonTest
	bcf		Brake_b
BrakeAgain
	call	PBUTTON_STATUS
	btfss	Brake_b
		bra BrakeAgain
	TurnOffLED	Ilimit
	bcf		StartStop_b
;..............................................................................
; 	HALL_A, HALL_B, and HALL_C interupt input tests
;
;	The test method is to short the HA, HB, and HC, inputs, one at a time,
;	while observing that LED0, LED1, and LED2 turn on. Because this test is
;	interrupt driven, the code here only monitors that the LEDs are turned on.
;	The test ends when all three LEDs are on. After a pause, LED3 also turns on
;	indicating the beginning of the Dip switch test.
;..............................................................................

HallinputsTest
	bsf		TestModeActive_b
	call	LOAD_PDC
	movlw	UPPER TestSequence 	;Note that all sequence data is located in
	movwf	TBLPTRU				; high memory 
	movlw	HIGH TestSequence 	
	movwf 	TBLPTRH
	movlw	low TestSequence 
	movwf	TBLPTRLsave

	bsf		ForwardMotor_b
	bsf		SeqEnabled_b
	call 	UPDATE_SEQUENCE
	
TestHallAgain
	btfss	LED0Enabled_b
		bra TestHallAgain
	btfss	LED1Enabled_b
		bra TestHallAgain
	btfss	LED2Enabled_b
		bra TestHallAgain
	movlw	d'50'
	call	DELAY_
	TurnOnLED LED3,NoBlink
;..............................................................................
;	Dip switch tests
;	Each dip switch is set to open (off) on at a time and the correcponding LED
;   turns off to indicate the valid operation of multiplexed dip switch circuit.
;..............................................................................
DipSwitchTest
	EnableMux DipSwitch, DipSwInputs
	movlw	0xF0
	andwf	DipSwInputs			;clear b0..b3
	movf	DipSwInputs,W
	TurnOffLED Wdata
	movlw	5
	Call	DELAY_
	clrf	WREG
	cpfseq	DipSwInputs			;repeat until all switches are off
	bra		DipSwitchTest		
	
;..............................................................................
; A/D converter and potentiometer test
; This test requires that the speed pot is turned fully to a maximum position
; (right rotation). When the tap voltage is at a maximum (close to 5V),
; LED0 turns on. Now, as the pot setting is decreased (left rotation), LEDs 1,
; 2, and 3 turn on one at a time as the pot setting is decreased towards 0V.
;..............................................................................
A2Dtest	
	btfss	ADCenConvert_b	
		bsf	ADCenConvert_b		;Start the ADC conversion.
WaitForData
 	btfss	UpdatePWM_b			;When set, ADC has provided new values
		bra	WaitForData			;Update PWM duty cycle
	bcf		UpdatePWM_b
	bcf		STATUS,C
	rrcf	SpeedRef_H
	rrcf	SpeedRef_L
	bcf		STATUS,C
	rrcf	SpeedRef_H
	rrcf	SpeedRef_L
Level1
	btfsc	LED0Enabled_b
		bra Level2
	movlw	0xF2				;95% of 5V
	cpfsgt	SpeedRef_L
		bra A2Dtest
	movlw	0xF0
	TurnOnLED	Wdata, NoBlink	;turn on all leds
Level2
	movlw	0xB9				;72% of 5V
	cpfslt	SpeedRef_L
		bra A2Dtest
	TurnOffLED	LED3			;turn off led3
Level3
	movlw	0x80				;50% of 5V
	cpfslt	SpeedRef_L
		bra A2Dtest
	movlw	0x03
	TurnOffLED	LED2			;turn off led2
Level4
	movlw	0x46				;27% of 5V
	cpfslt	SpeedRef_L
		bra A2Dtest
	TurnOffLED	LED1			;turn off led1
Level5
	movlw	0x0D				;5% of 5V
	cpfslt	SpeedRef_L
		bra A2Dtest
	TurnOffLED	LED0			;turn off led0, all LEDS are off
xA2Dtest

;..............................................................................
; Measured motor current test
; as a compromise to minimize the test setup complexity, the measure motor
; current is monitored with no load. Because current sensing is bipolar, with 
; no current through the current sense resistors, the output of the analog
; circuit is 1/2 of the 5V bias voltage. The nominal A/D value at no load is 
; 0x200. The acceptable measurement error is  +/- 5% (0x21A and 0x1E6)
;
; If the current measuring test concludes with in tolerance current sense
; values, the TestMode proceedure is completed with the 4 leds turning on and
; off one at a time, shifting from LED0 to LED3. If the current measurement is
; out of tolerance, the testMode proceedure also ends but with all 4 LEDs
; turning on and off simultaneously.
;
; Normal operation is restored by setting the dip switches for the required
; BLDC switching sequence and then pushing the reset button cycling the VBat
; voltage.
;..............................................................................
NoLoadCurrent
	bcf		TestModeActive_b
	movlw	0x02
	cpfseq	MotorCurrent_H
		bra TestLowLimit
	movlw	0x1A
	cpfsgt  MotorCurrent_L		;test for motor current > 5% of 0x200
		bra LimitsOk		
	bra		ErrorCurrent		;measured motor current is greater than 0x021A
TestLowLimit	
	movlw	0x01
	cpfseq	MotorCurrent_H
		bra ErrorCurrent
	movlw   0xE6
	cpfslt	MotorCurrent_L		;test for motor current < 5% of 0x200
		bra LimitsOk
ErrorCurrent					;measured motor current is less than 0x021A
	movlw	0xF0
	TurnOnLED Wdata,Blink
	bra		$					;current measurement error
LimitsOk
	movlw	35
	Call	DELAY_
;..............................................................................
; Test Completed. Reset to restart
;..............................................................................
FlashLEDs
	movlw	0x10
	call	NextLED
	movlw	0x20
	call	NextLED
	movlw	0x40
	call	NextLED
	movlw	0x80
	call	NextLED
	bra 	FlashLEDs
	
NextLED	
	TurnOnLED	Wdata,NoBlink
	movlw	5
	call DELAY_
	return
		
